﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.BaseCode
{
    public partial class ServiceInterfaceManager
    {
        //DNS: Removing unused and consolidating from the cg.cs file in prep for Fortify

        private static CrsServices services = new CrsServices() { Credentials = System.Net.CredentialCache.DefaultCredentials };

        private int referralCommonCount;
        private int totalCount;

        public static string GET_VERSION()
        {
            return services.GET_VERSION();
        }

        #region APPLICATION_STATUS
        #endregion

        #region BCCCR_BCR_ALL

        public static List<BCCCR_BCR_ALL> BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(string CURRENT_USER, int CURRENT_REGISTRY_ID, short STA3N, string PATIENT_SEARCH)
        {
            BCCCR_BCR_ALL[] temp = services.BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(CURRENT_USER, CURRENT_REGISTRY_ID, STA3N, PATIENT_SEARCH);
            if (temp != null)
                return temp.ToList<BCCCR_BCR_ALL>();
            return null;
        }

        public static List<BCCCR_BCR_ALL> BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(string CURRENT_USER, int CURRENT_REGISTRY_ID, short STA3N, string PATIENT_SEARCH, string SORT_EXPRESSION)
        {
            List<BCCCR_BCR_ALL> objReturn = BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(CURRENT_USER, CURRENT_REGISTRY_ID, STA3N, PATIENT_SEARCH);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<BCCCR_BCR_ALL>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<BCCCR_BCR_ALL>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<BCCCR_BCR_ALL>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<BCCCR_BCR_ALL>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<BCCCR_BCR_ALL>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<BCCCR_BCR_ALL>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region DATA_DICTIONARY

        public static List<DATA_DICTIONARY> DATA_DICTIONARY_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            DATA_DICTIONARY[] temp = services.DATA_DICTIONARY_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<DATA_DICTIONARY>();
            return null;
        }

        public static List<DATA_DICTIONARY> DATA_DICTIONARY_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<DATA_DICTIONARY> objReturn = DATA_DICTIONARY_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<DATA_DICTIONARY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<DATA_DICTIONARY>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<DATA_DICTIONARY>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<DATA_DICTIONARY>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<DATA_DICTIONARY>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<DATA_DICTIONARY>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<DATA_DICTIONARY>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<DATA_DICTIONARY>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<DATA_DICTIONARY>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region DB_LOG

        public static int DB_LOG_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, DB_LOG objSave)
        {
            return services.DB_LOG_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        #endregion

        #region DIM_TIME
        #endregion

        #region EFR_ALL

        #endregion

        #region ETL_ExtractBatch_Log

        public static List<ETL_ExtractBatch_Log> ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            ETL_ExtractBatch_Log[] temp = services.ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<ETL_ExtractBatch_Log>();
            return null;
        }

        public static List<ETL_ExtractBatch_Log> ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<ETL_ExtractBatch_Log> objReturn = ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<ETL_ExtractBatch_Log>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<ETL_ExtractBatch_Log>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<ETL_ExtractBatch_Log>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<ETL_ExtractBatch_Log>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<ETL_ExtractBatch_Log>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<ETL_ExtractBatch_Log>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<ETL_ExtractBatch_Log>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<ETL_ExtractBatch_Log>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<ETL_ExtractBatch_Log>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region INDIVIDUAL
        #endregion

        #region INDIVIDUAL_ADDRESS
        #endregion

        #region MESSAGE_LOG
        #endregion

        #region PATIENT

        public static PATIENT PATIENT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.PATIENT_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static PATIENT PATIENT_GET_COMPLETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID)
        {
            return services.PATIENT_GET_COMPLETE(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
        }

        public static List<PATIENT> PATIENT_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            PATIENT[] temp = services.PATIENT_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<PATIENT>();
            return null;
        }

        public static List<PATIENT> PATIENT_GET_ALL_BY_NAME(string CURRENT_USER, int CURRENT_REGISTRY_ID, string LAST_NAME, string FIRST_NAME)
        {
            PATIENT[] temp = services.PATIENT_GET_ALL_BY_NAME(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME);
            if (temp != null)
                return temp.ToList<PATIENT>();
            return null;
        }

        //public static int PATIENT_GET_COMMON_BY_REGISTRY_COUNT(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT)
        //{
        //    return services.PATIENT_GET_COMMON_BY_REGISTRY_COUNT(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT);
        //}

        //public static List<REFERRALcommon> PATIENT_GET_COMMON_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS)
        //{
        //    REFERRALcommon[] temp = services.PATIENT_GET_COMMON_BY_REGISTRY_FILTER(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS);
        //    if (temp != null)
        //        return temp.ToList<REFERRALcommon>();
        //    return null;
        //}

        #endregion

        #region PATIENT

        public static PATIENT_REG PATIENT_REG_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.PATIENT_REG_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region PATIENT_IDS
        #endregion

        #region PATIENT_UDFs

        public static int PATIENT_UDFs_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, PATIENT_UDFs objSave)
        {
            return services.PATIENT_UDFs_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static PATIENT_UDFs PATIENT_UDFs_GET_BY_PATIENT_UDF(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID, int STD_REG_UDFs_ID)
        {
            return services.PATIENT_UDFs_GET_BY_PATIENT_UDF(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID, STD_REG_UDFs_ID);
        }

        #endregion

        #region REFERRAL

        public static REFERRAL REFERRAL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.REFERRAL_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static REFERRAL REFERRAL_GET_BY_PATIENTICN(string CURRENT_USER, int CURRENT_REGISTRY_ID, string patientIcn)
        {
            return services.REFERRAL_GET_BY_PATIENTICN(CURRENT_USER, CURRENT_REGISTRY_ID, patientIcn);
        }

        public static int REFERRAL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, REFERRAL objSave)
        {
            return services.REFERRAL_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean REFERRAL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.REFERRAL_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static REFERRAL REFERRAL_GET_COMPLETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int REFERRAL_ID)
        {
            return services.REFERRAL_GET_COMPLETE(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);
        }

        public static List<REFERRAL> REFERRAL_GET_ALL_BY_REGISTRY_STATUS(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_REFERRALSTS_ID)
        {
            REFERRAL[] temp = services.REFERRAL_GET_ALL_BY_REGISTRY_STATUS(CURRENT_USER, CURRENT_REGISTRY_ID, STD_REFERRALSTS_ID);
            if (temp != null)
                return temp.ToList<REFERRAL>();
            return null;
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            REFERRALcommon[] temp = services.REFERRAL_GET_COMMON_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<REFERRALcommon>();
            return null;
        }

        //public static int REFERRAL_GET_COMMON_BY_REGISTRY_COUNT(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT)
        //{
        //    return services.REFERRAL_GET_COMMON_BY_REGISTRY_COUNT(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT);
        //}

        public int REFERRAL_GET_COMMON_BY_REGISTRY_COUNT(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID, string SEARCH_COLUMN, string SEARCH_TEXT, bool IsPatientList)
        {
            return this.referralCommonCount;
        }

        public List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS, bool IsPatientList)
        {
            REFERRALcommonGroup col = services.REFERRAL_GET_COMMON_BY_REGISTRY_FILTER(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS, IsPatientList);
            if (col != null)
            {
                REFERRALcommon[] temp = col.ReferralCommon;
                if (temp != null)
                {
                    this.referralCommonCount = col.CompleteCount;
                    var list = temp.ToList<REFERRALcommon>();
                    return list;
                }
            }
            return null;
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PATIENT(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID)
        {
            REFERRALcommon[] temp = services.REFERRAL_GET_COMMON_BY_PATIENT(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
            if (temp != null)
                return temp.ToList<REFERRALcommon>();
            return null;
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PATIENT(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<REFERRALcommon> objReturn = REFERRAL_GET_COMMON_BY_PATIENT(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                                }
                            }
                            else
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList();
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                                }
                            }
                            else
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList();
                        }
                    }
                }
            }
            return objReturn;
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PROVIDER(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PROVIDER_ID)
        {
            REFERRALcommon[] temp = services.REFERRAL_GET_COMMON_BY_PROVIDER(CURRENT_USER, CURRENT_REGISTRY_ID, PROVIDER_ID);
            if (temp != null)
                return temp.ToList<REFERRALcommon>();
            return null;
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PROVIDER(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PROVIDER_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<REFERRALcommon> objReturn = REFERRAL_GET_COMMON_BY_PROVIDER(CURRENT_USER, CURRENT_REGISTRY_ID, PROVIDER_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                                }
                            }
                            else
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList();
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                                }
                            }
                            else
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList();
                        }
                    }
                }
            }

            return objReturn;
        }

        public static bool REFERRAL_PATIENT_EXISTS(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID)
        {
            return services.REFERRAL_PATIENT_EXISTS(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
        }

        public static int REFERRAL_SAVE_MANUAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID, int PROVIDER_ID)
        {
            return services.REFERRAL_SAVE_MANUAL(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID, PROVIDER_ID);
        }

        public static List<SearchResult> RESULTS_GET_ALL_BY_NAME(string CURRENT_USER, int CURRENT_REGISTRY_ID, string LAST_NAME, string FIRST_NAME, string SEARCH_TYPE)
        {
            List<SearchResult> objReturn = null;

            if (SEARCH_TYPE == "PATIENT")
            {
                PATIENT[] temp = services.PATIENT_GET_ALL_BY_NAME(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME);
                if (temp != null)
                    objReturn = temp.Select(r => new SearchResult()
                    {
                        BirthDate = r.BIRTH_DATE.GetValueOrDefault(),
                        City = r.SPATIENT.City,
                        FirstName = r.FIRST_NAME,
                        LastFour = r.SPATIENT.PatientLastFour,
                        LastName = r.LAST_NAME,
                        Gender = r.SPATIENT.Gender,
                        PostalCode = r.SPATIENT.PostalCode,
                        ResultId = r.PATIENT_ID,
                        State = r.SPATIENT.State
                    }).ToList<SearchResult>();
            }
            else if (SEARCH_TYPE == "PROVIDER")
            {
                SStaff_SStaff[] temp = services.SStaff_SStaff_GET_ALL_BY_NAME(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME);
                if (temp != null)
                    objReturn = temp.Select(r => new SearchResult()
                    {
                        BirthDate = null,
                        City = r.City,
                        FirstName = r.FirstName,
                        LastFour = string.Empty,
                        LastName = r.LastName,
                        Gender = r.Gender,
                        PostalCode = r.ZipCode,
                        ResultId = r.Provider_ID,
                        State = r.StateName
                    }).ToList<SearchResult>();
            }

            return objReturn;
        }

        public static List<SearchResult> RESULTS_GET_ALL_BY_NAME(string CURRENT_USER, int CURRENT_REGISTRY_ID, string LAST_NAME, string FIRST_NAME, string SEARCH_TYPE, string SORT_EXPRESSION, string SEARCH_COLUMN, string SEARCH_TEXT)
        {
            // List<SearchResult> objReturn = null;
            List<SearchResult> objReturn = null;

            if (SEARCH_TYPE == "PATIENT")
            {
                PATIENT[] temp = services.PATIENT_GET_ALL_BY_NAME(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME);
                if (temp != null)
                    objReturn = temp.Select(r => new SearchResult()
                    {
                        BirthDate = r.BIRTH_DATE.GetValueOrDefault(),
                        City = r.SPATIENT.City,
                        FirstName = r.FIRST_NAME,
                        LastFour = r.SPATIENT.PatientLastFour,
                        LastName = r.LAST_NAME,
                        Gender = r.SPATIENT.Gender,
                        PostalCode = r.SPATIENT.PostalCode,
                        ResultId = r.PATIENT_ID,
                        State = r.SPATIENT.State
                    }).ToList<SearchResult>();
            }
            else if (SEARCH_TYPE == "PROVIDER")
            {
                SStaff_SStaff[] temp = services.SStaff_SStaff_GET_ALL_BY_NAME(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME);
                if (temp != null)
                    objReturn = temp.Select(r => new SearchResult()
                    {
                        BirthDate = null,
                        City = r.City,
                        FirstName = r.FirstName,
                        LastFour = string.Empty,
                        LastName = r.LastName,
                        Gender = r.Gender,
                        PostalCode = r.ZipCode,
                        ResultId = r.Provider_ID,
                        State = r.StateName
                    }).ToList<SearchResult>();
            }

            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<SearchResult>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<SearchResult>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<SearchResult>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<SearchResult>();
                                }
                            }
                            else
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<SearchResult>();
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<SearchResult>();
                                }
                            }
                            else
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<SearchResult>();
                        }
                    }
                }
            }
            return objReturn;
        }

        public static bool REFERRAL_UPDATE_STATUS(string CURRENT_USER, int CURRENT_REGISTRY_ID, int REFERRAL_ID, int STD_REFERRALSTS_ID)
        {
            return services.REFERRAL_UPDATE_STATUS(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, STD_REFERRALSTS_ID);
        }

        #endregion

        #region REFERRAL_DETAIL
        #endregion

        #region REGISTRY_COHORT_DATA

        public static List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            REGISTRY_COHORT_DATA[] temp = services.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<REGISTRY_COHORT_DATA>();
            return null;
        }

        public static List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            REGISTRY_COHORT_DATA[] temp = services.REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<REGISTRY_COHORT_DATA>();
            return null;
        }

        public static int REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT(string CURRENT_USER, int CURRENT_REGISTRY_ID, List<REGISTRY_COHORT_DATA> cohorts)
        {
            REGISTRY_COHORT_DATA[] temp = (cohorts != null ? cohorts.ToArray() : null);
            return services.REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT(CURRENT_USER, CURRENT_REGISTRY_ID, temp);
        }

        public static bool REGISTRY_COHORT_DATA_SAVE_LIST(string CURRENT_USER, int CURRENT_REGISTRY_ID, List<REGISTRY_COHORT_DATA> cohorts)
        {
            REGISTRY_COHORT_DATA[] temp = (cohorts != null ? cohorts.ToArray() : null);
            return services.REGISTRY_COHORT_DATA_SAVE_LIST(CURRENT_USER, CURRENT_REGISTRY_ID, temp);
        }

        #endregion

        #region REGISTRY_CORE_DATA

        public static REGISTRY_CORE_DATA REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CORE_TYPE_ID)
        {
            return services.REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE(CURRENT_USER, CURRENT_REGISTRY_ID, CORE_TYPE_ID);
        }

        public static List<REGISTRY_CORE_DATA> REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            REGISTRY_CORE_DATA[] temp = services.REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<REGISTRY_CORE_DATA>();
            return null;
        }

        public static bool REGISTRY_CORE_DATA_SAVE_LIST(string CURRENT_USER, int CURRENT_REGISTRY_ID, List<REGISTRY_CORE_DATA> cores)
        {
            REGISTRY_CORE_DATA[] temp = (cores != null ? cores.ToArray() : null);
            return services.REGISTRY_CORE_DATA_SAVE_LIST(CURRENT_USER, CURRENT_REGISTRY_ID, temp);
        }

        #endregion

        #region ROLE_PERMISSIONS
        #endregion

        #region SETTINGS

        public static int SETTINGS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, SETTINGS objSave)
        {
            return services.SETTINGS_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static List<SETTINGS> SETTINGS_GET()
        {
            SETTINGS[] temp = services.SETTINGS_GET();
            if (temp != null)
                return temp.ToList();
            return null;
        }

        public static SETTINGS SETTINGS_GET_REGISTRYNAME(string CURRENT_USER, int CURRENT_REGISTRY_ID, string NAME)
        {
            return services.SETTINGS_GET_REGISTRYNAME(CURRENT_USER, CURRENT_REGISTRY_ID, NAME);
        }

        public static SETTINGS GET_HOME_PAGE_SETTING()
        {
            return services.SETTINGS_GET_HOME_PAGE();
        }

        #endregion

        #region SPATIENT
        #endregion

        #region SStaff_SStaff

        public static SStaff_SStaff SStaff_SStaff_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.SStaff_SStaff_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT)
        {
            //return services.SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT);
            return services.SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER_COUNT(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, "");
        }

        public static List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS)
        {
            //SStaff_SStaff[] temp = services.SStaff_SStaff_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS);
            SStaff_SStaff[] temp = services.SStaff_SStaff_GET_ALL_BY_REGISTRY_FILTER(CURRENT_USER, CURRENT_REGISTRY_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS);
            if (temp != null)
                return temp.ToList<SStaff_SStaff>();
            return null;
        }

        public static List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_NAME(string CURRENT_USER, int CURRENT_REGISTRY_ID, string LAST_NAME, string FIRST_NAME)
        {
            SStaff_SStaff[] temp = services.SStaff_SStaff_GET_ALL_BY_NAME(CURRENT_USER, CURRENT_REGISTRY_ID, LAST_NAME, FIRST_NAME);
            if (temp != null)
                return temp.ToList<SStaff_SStaff>();
            return null;
        }

        #endregion

        #region STD_GENDER

        public static STD_GENDER STD_GENDER_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_GENDER_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_GENDER> STD_GENDER_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_GENDER[] temp = services.STD_GENDER_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_GENDER>();
            return null;
        }

        public static int STD_GENDER_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_GENDER objSave)
        {
            return services.STD_GENDER_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_GENDER_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_GENDER_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_COUNTRY
        #endregion

        #region STD_GUI_CONTROLS
        public static List<STD_GUI_CONTROLS> STD_GUI_CONTROLS_GetByCategory(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string category)
        {
            STD_GUI_CONTROLS[] temp = services.STD_GUI_CONTROLS_GetByCategory(CURRENT_USER, CURRENT_REGISTRY_ID, category);
            if (temp != null)
                return temp.ToList<STD_GUI_CONTROLS>();
            return null;
        }
        #endregion

        #region STD_INDIVIDUAL_GROUP
        #endregion

        #region STD_INDIVIDUAL_TYPE
        #endregion

        #region STD_INSTITUTION

        public static STD_INSTITUTION STD_INSTITUTION_GET_COMPLETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_INSTITUTION_GET_COMPLETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_INSTITUTION> STD_INSTITUTION_GET_FACS(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_INSTITUTION[] temp = services.STD_INSTITUTION_GET_FACS(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_INSTITUTION>();
            return null;
        }

        public static List<STD_INSTITUTION> STD_INSTITUTION_GET_VISNS(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_INSTITUTION[] temp = services.STD_INSTITUTION_GET_VISNS(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_INSTITUTION>();
            return null;
        }

        public static List<STD_INSTITUTION> STD_INSTITUTION_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_INSTITUTION[] temp = services.STD_INSTITUTION_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_INSTITUTION>();
            return null;
        }

        public static List<STD_INSTITUTION> STD_INSTITUTION_GET_FACILITIES(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_INSTITUTION[] temp = services.STD_INSTITUTION_GET_FACILITIES(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_INSTITUTION>();
            return null;
        }

        public static bool STD_INSTITUTION_SAVE_VISNS(string CURRENT_USER, int CURRENT_REGISTRY_ID, int USER_ID, List<int> visnIds)
        {
            int[] temp = (visnIds != null ? visnIds.ToArray() : null);
            return services.STD_INSTITUTION_SAVE_VISNS(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, temp);
        }

        public static bool STD_INSTITUTION_SAVE_FACILITIES(string CURRENT_USER, int CURRENT_REGISTRY_ID, int USER_ID, List<int> facIds)
        {
            int[] temp = (facIds != null ? facIds.ToArray() : null);
            return services.STD_INSTITUTION_SAVE_FACILITIES(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, temp);
        }

        public static List<STD_INSTITUTION> USER_SITES_GET_ALL_VISNS_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID, int USER_ID)
        {
            STD_INSTITUTION[] temp = services.USER_SITES_GET_ALL_VISNS_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID);
            if (temp != null)
                return temp.ToList<STD_INSTITUTION>();
            return null;
        }

        public static List<STD_INSTITUTION> USER_SITES_GET_ALL_FACILITIES_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID, int USER_ID)
        {
            STD_INSTITUTION[] temp = services.USER_SITES_GET_ALL_FACILITIES_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID);
            if (temp != null)
                return temp.ToList<STD_INSTITUTION>();
            return null;
        }

        #endregion

        #region STD_MENU_ITEMS

        public static STD_MENU_ITEMS STD_MENU_ITEMS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_MENU_ITEMS_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_MENU_ITEMS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_MENU_ITEMS objSave)
        {
            return services.STD_MENU_ITEMS_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_MENU_ITEMS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_MENU_ITEMS_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_MENU_ITEMS[] temp = services.STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_MENU_ITEMS>();
            return null;
        }

        public static List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_ROLE_ID)
        {
            List<STD_MENU_ITEMS> temp = STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null && STD_ROLE_ID > 0)
            {
                temp = temp.Where(w => w.STD_ROLE_ID == STD_ROLE_ID).ToList();
            }

            return temp;
        }

        public static List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_ROLE_ID, string SORT_EXPRESSION, string SEARCH_COLUMN, string SEARCH_TEXT)
        {
            List<STD_MENU_ITEMS> objReturn = STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID, STD_ROLE_ID);

            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_MENU_ITEMS>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_MENU_ITEMS>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_MENU_ITEMS>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_MENU_ITEMS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_MENU_ITEMS>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_MENU_ITEMS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_MENU_ITEMS>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_MENU_ITEMS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_MENU_ITEMS>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<STD_WEB_PAGES> STD_WEB_PAGES_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SORT_EXPRESSION, string SEARCH_COLUMN, string SEARCH_TEXT)
        {
            List<STD_WEB_PAGES> objReturn = STD_WEB_PAGES_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);

            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_WEB_PAGES>();
                            }
                            else
                            {
                                objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_WEB_PAGES>();
                                objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_WEB_PAGES>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_WEB_PAGES>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_WEB_PAGES>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length > 3)
                        {
                            if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                            {
                                SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                                if (SORT_EXPRESSION.Contains("."))
                                {
                                    string[] props = SORT_EXPRESSION.Split('.');
                                    if (props != null && props.Count() == 2)
                                    {
                                        objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WEB_PAGES>();
                                    }
                                }
                                else
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WEB_PAGES>();
                            }
                            else
                            {
                                if (SORT_EXPRESSION.Contains("."))
                                {
                                    string[] props = SORT_EXPRESSION.Split('.');
                                    if (props != null && props.Count() == 2)
                                    {
                                        objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WEB_PAGES>();
                                    }
                                }
                                else
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WEB_PAGES>();
                                }
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WEB_PAGES>();
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WEB_PAGES>();
                            }
                        }
                    }
                }
            }
            return objReturn;
        }

        public static CrsMenu STD_MENU_ITEMS_GET_MENU(string CURRENT_USER, int CURRENT_REGISTRY_ID, string PATH)
        {
            CrsMenu crsMenu = null;

            STD_MENU_ITEMS[] temp = services.STD_MENU_ITEMS_GET_MENU(CURRENT_USER, CURRENT_REGISTRY_ID, PATH);
            if (temp != null)
            {
                List<CrsMenuItem> menuItems = new List<CrsMenuItem>();

                foreach (STD_MENU_ITEMS item in temp)
                {
                    if (item.MENU_PAGE != null)
                        menuItems.Add(new CrsMenuItem(item.MENU_PAGE.DISPLAY_TEXT, item.MENU_PAGE.URL));
                }

                crsMenu = new CrsMenu(menuItems);
            }

            return crsMenu;
        }

        #endregion

        #region STD_QUESTION

        public static STD_QUESTION STD_QUESTION_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_QUESTION_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_QUESTION_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_QUESTION objSave)
        {
            return services.STD_QUESTION_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_QUESTION_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_QUESTION_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_QUESTION> STD_QUESTION_GET_ALL_BY_SURVEY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_SURVEY_TYPE_ID)
        {
            STD_QUESTION[] temp = services.STD_QUESTION_GET_ALL_BY_SURVEY(CURRENT_USER, CURRENT_REGISTRY_ID, STD_SURVEY_TYPE_ID);
            if (temp != null)
                return temp.ToList<STD_QUESTION>();
            return null;
        }

        public static List<STD_QUESTION> STD_QUESTION_GET_ALL_BY_SURVEY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_SURVEY_TYPE_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<STD_QUESTION> objReturn = STD_QUESTION_GET_ALL_BY_SURVEY(CURRENT_USER, CURRENT_REGISTRY_ID, STD_SURVEY_TYPE_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_QUESTION>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_QUESTION>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_QUESTION>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_QUESTION>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_QUESTION>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_QUESTION>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_QUESTION>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_QUESTION>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_QUESTION>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static bool STD_QUESTION_COPY_CHOICES(string CURRENT_USER, int CURRENT_REGISTRY_ID, int OLD_QUESTION_ID, int NEW_QUESTION_ID)
        {
            return services.STD_QUESTION_COPY_CHOICES(CURRENT_USER, CURRENT_REGISTRY_ID, OLD_QUESTION_ID, NEW_QUESTION_ID);
        }

        #endregion

        #region STD_QUESTION_CHOICE

        public static STD_QUESTION_CHOICE STD_QUESTION_CHOICE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_QUESTION_CHOICE_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_QUESTION_CHOICE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_QUESTION_CHOICE objSave)
        {
            return services.STD_QUESTION_CHOICE_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_QUESTION_CHOICE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_QUESTION_CHOICE_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_QUESTION_CHOICE> STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_QUESTION_ID)
        {
            STD_QUESTION_CHOICE[] temp = services.STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(CURRENT_USER, CURRENT_REGISTRY_ID, STD_QUESTION_ID);
            if (temp != null)
                return temp.ToList<STD_QUESTION_CHOICE>();
            return null;
        }

        public static List<STD_QUESTION_CHOICE> STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_QUESTION_ID, string SORT_EXPRESSION, string SEARCH_COLUMN, string SEARCH_TEXT)
        {
            List<STD_QUESTION_CHOICE> objReturn = STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(CURRENT_USER, CURRENT_REGISTRY_ID, STD_QUESTION_ID);

            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_QUESTION_CHOICE>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_QUESTION_CHOICE>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_QUESTION_CHOICE>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_QUESTION_CHOICE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_QUESTION_CHOICE>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_QUESTION_CHOICE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_QUESTION_CHOICE>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_QUESTION_CHOICE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_QUESTION_CHOICE>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region STD_REFERRALSTS

        public static STD_REFERRALSTS STD_REFERRALSTS_GET_BY_CODE(string CURRENT_USER, int CURRENT_REGISTRY_ID, string CODE)
        {
            return services.STD_REFERRALSTS_GET_BY_CODE(CURRENT_USER, CURRENT_REGISTRY_ID, CODE);
        }

        #endregion

        #region STD_REG_UDFs

        public static STD_REG_UDFs STD_REG_UDFs_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_REG_UDFs_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_REG_UDFs_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_REG_UDFs objSave)
        {
            return services.STD_REG_UDFs_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_REG_UDFs_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_REG_UDFs_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_REG_UDFs> STD_REG_UDFs_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_REG_UDFs[] temp = services.STD_REG_UDFs_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_REG_UDFs>();
            return null;
        }

        public static List<STD_REG_UDFs> STD_REG_UDFs_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<STD_REG_UDFs> objReturn = STD_REG_UDFs_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_REG_UDFs>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_REG_UDFs>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_REG_UDFs>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REG_UDFs>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REG_UDFs>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REG_UDFs>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REG_UDFs>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REG_UDFs>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REG_UDFs>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region STD_REGISTRY

        public static STD_REGISTRY STD_REGISTRY_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_REGISTRY_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_REGISTRY_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_REGISTRY objSave)
        {
            return services.STD_REGISTRY_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_REGISTRY_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_REGISTRY_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static STD_REGISTRY STD_REGISTRY_GET_COMPLETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int ID)
        {
            return services.STD_REGISTRY_GET_COMPLETE(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
        }

        public static STD_REGISTRY STD_REGISTRY_GET_SYSTEM()
        {
            return services.STD_REGISTRY_GET_SYSTEM();
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_REGISTRY[] temp = services.STD_REGISTRY_GET_ALL_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_REGISTRY>();
            return null;
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<STD_REGISTRY> objReturn = STD_REGISTRY_GET_ALL_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_REGISTRY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_REGISTRY>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_REGISTRY>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REGISTRY>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REGISTRY>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REGISTRY>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REGISTRY>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REGISTRY>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REGISTRY>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM()
        {
            STD_REGISTRY[] temp = services.STD_REGISTRY_GET_ALL_NON_SYSTEM();
            if (temp != null)
                return temp.ToList<STD_REGISTRY>();
            return null;
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_REGISTRY[] temp = services.STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_REGISTRY>();
            return null;
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SORT_EXPRESSION, string SEARCH_COLUMN, string SEARCH_TEXT)
        {
            List<STD_REGISTRY> objReturn = STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_REGISTRY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_REGISTRY>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_REGISTRY>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REGISTRY>();
                                }
                            }
                            else
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REGISTRY>();
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_REGISTRY>();
                                }
                            }
                            else
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_REGISTRY>();
                        }
                    }
                }
            }
            return objReturn;
        }

        #endregion

        #region STD_REGISTRY_CODES
        #endregion

        #region STD_REGISTRY_COHORT_TYPES
        #endregion

        #region STD_REGISTRY_CORE_TYPES
        #endregion

        #region STD_ROLE

        public static STD_ROLE STD_ROLE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_ROLE_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_SYSTEM_ROLES(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_ROLE[] temp = services.STD_ROLE_GET_ALL_SYSTEM_ROLES(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_ROLE>();
            return null;
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_REGISTRY_ROLES(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_ROLE[] temp = services.STD_ROLE_GET_ALL_REGISTRY_ROLES(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_ROLE>();
            return null;
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_REGISTRY_ROLES(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<STD_ROLE> objReturn = STD_ROLE_GET_ALL_REGISTRY_ROLES(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_ROLE>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_ROLE>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_ROLE>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_ROLE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_ROLE>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_ROLE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_ROLE>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_ROLE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_ROLE>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_BY_USER_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_ROLE[] temp = services.STD_ROLE_GET_ALL_BY_USER_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_ROLE>();
            return null;
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_BY_USER_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string STD_ROLE_ID, string SORT_EXPRESSION, string SEARCH_COLUMN, string SEARCH_TEXT)
        {
            List<STD_ROLE> objReturn = STD_ROLE_GET_ALL_BY_USER_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_ROLE>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_ROLE>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_ROLE>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_ROLE>();
                                }
                            }
                            else
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_ROLE>();
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_ROLE>();
                                }
                            }
                            else
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_ROLE>();
                        }
                    }
                }
            }
            return objReturn;
        }

        #endregion

        #region STD_SERVICE_OCCUPATION
        #endregion

        #region STD_STATE
        #endregion

        #region STD_SURVEY_SECTION
        #endregion

        #region STD_SURVEY_SUB_SECTION
        #endregion

        #region STD_SURVEY_TYPE

        public static STD_SURVEY_TYPE STD_SURVEY_TYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_SURVEY_TYPE_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_SURVEY_TYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SURVEY_TYPE objSave)
        {
            return services.STD_SURVEY_TYPE_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_SURVEY_TYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_SURVEY_TYPE_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_SURVEY_TYPE> STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_SURVEY_TYPE[] temp = services.STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_SURVEY_TYPE>();
            return null;
        }

        public static List<STD_SURVEY_TYPE> STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<STD_SURVEY_TYPE> objReturn = STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_SURVEY_TYPE>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_SURVEY_TYPE>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_SURVEY_TYPE>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_SURVEY_TYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_SURVEY_TYPE>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_SURVEY_TYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_SURVEY_TYPE>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_SURVEY_TYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_SURVEY_TYPE>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region STD_USER_ACTIVITY_TYPE
        #endregion

        #region STD_WEB_PAGES

        public static STD_WEB_PAGES STD_WEB_PAGES_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WEB_PAGES_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_WEB_PAGES> STD_WEB_PAGES_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_WEB_PAGES[] temp = services.STD_WEB_PAGES_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_WEB_PAGES>();
            return null;
        }

        public static int STD_WEB_PAGES_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_WEB_PAGES objSave)
        {
            return services.STD_WEB_PAGES_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_WEB_PAGES_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WEB_PAGES_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_WKFACTIVITYSTS

        public static STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WKFACTIVITYSTS_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET_BY_CODE(string CURRENT_USER, int CURRENT_REGISTRY_ID, string CODE)
        {
            return services.STD_WKFACTIVITYSTS_GET_BY_CODE(CURRENT_USER, CURRENT_REGISTRY_ID, CODE);
        }

        #endregion

        #region STD_WKFACTIVITYTYPE

        public static STD_WKFACTIVITYTYPE STD_WKFACTIVITYTYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WKFACTIVITYTYPE_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_WKFACTIVITYTYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_WKFACTIVITYTYPE objSave)
        {
            return services.STD_WKFACTIVITYTYPE_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_WKFACTIVITYTYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WKFACTIVITYTYPE_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_WKFACTIVITYTYPE[] temp = services.STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_WKFACTIVITYTYPE>();
            return null;
        }

        public static List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<STD_WKFACTIVITYTYPE> objReturn = STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_WKFACTIVITYTYPE>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_WKFACTIVITYTYPE>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_WKFACTIVITYTYPE>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WKFACTIVITYTYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WKFACTIVITYTYPE>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WKFACTIVITYTYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WKFACTIVITYTYPE>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WKFACTIVITYTYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WKFACTIVITYTYPE>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_WKFCASETYPE_ID)
        {
            STD_WKFACTIVITYTYPE[] temp = services.STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM(CURRENT_USER, CURRENT_REGISTRY_ID, STD_WKFCASETYPE_ID);
            if (temp != null)
                return temp.ToList<STD_WKFACTIVITYTYPE>();
            return null;
        }

        #endregion

        #region STD_WKFCASESTS

        public static STD_WKFCASESTS STD_WKFCASESTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WKFCASESTS_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static STD_WKFCASESTS STD_WKFCASESTS_GET_BY_CODE(string CURRENT_USER, int CURRENT_REGISTRY_ID, string CODE)
        {
            return services.STD_WKFCASESTS_GET_BY_CODE(CURRENT_USER, CURRENT_REGISTRY_ID, CODE);
        }

        #endregion

        #region STD_WKFCASETYPE

        public static STD_WKFCASETYPE STD_WKFCASETYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WKFCASETYPE_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_WKFCASETYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_WKFCASETYPE objSave)
        {
            return services.STD_WKFCASETYPE_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_WKFCASETYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.STD_WKFCASETYPE_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_WKFCASETYPE> STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            STD_WKFCASETYPE[] temp = services.STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<STD_WKFCASETYPE>();
            return null;
        }

        public static List<STD_WKFCASETYPE> STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<STD_WKFCASETYPE> objReturn = STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_WKFCASETYPE>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<STD_WKFCASETYPE>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<STD_WKFCASETYPE>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WKFCASETYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WKFCASETYPE>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WKFCASETYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WKFCASETYPE>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<STD_WKFCASETYPE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<STD_WKFCASETYPE>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region SURVEY_NOTES
        #endregion

        #region SURVEY_RESULTS

        public static List<SURVEY_RESULTS> SURVEY_RESULTS_GET_ALL_BY_SURVEY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int SURVEY_ID)
        {
            SURVEY_RESULTS[] temp = services.SURVEY_RESULTS_GET_ALL_BY_SURVEY(CURRENT_USER, CURRENT_REGISTRY_ID, SURVEY_ID);
            if (temp != null)
                return temp.ToList<SURVEY_RESULTS>();
            return null;
        }

        public static bool SURVEY_RESULTS_SAVE_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID, List<SURVEY_RESULTS> RESULTS)
        {
            SURVEY_RESULTS[] temp = RESULTS.ToArray();
            return services.SURVEY_RESULTS_SAVE_ALL(CURRENT_USER, CURRENT_REGISTRY_ID, temp);
        }

        #endregion

        #region SURVEYS

        public static SURVEYS SURVEYS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.SURVEYS_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int SURVEYS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, SURVEYS objSave)
        {
            return services.SURVEYS_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean SURVEYS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.SURVEYS_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static SURVEYS SURVEYS_GET_FOR_SURVEY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int SURVEYS_ID)
        {
            return services.SURVEYS_GET_FOR_SURVEY(CURRENT_USER, CURRENT_REGISTRY_ID, SURVEYS_ID);
        }

        public static List<SURVEYS> SURVEYS_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            SURVEYS[] temp = services.SURVEYS_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<SURVEYS>();
            return null;
        }

        public static List<SURVEYS> SURVEYS_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<SURVEYS> objReturn = SURVEYS_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (PATIENT_ID > 0)
                {
                    objReturn = objReturn.Where(x => x.PATIENT_ID == PATIENT_ID).ToList();
                }
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<SURVEYS>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<SURVEYS>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<SURVEYS>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<SURVEYS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<SURVEYS>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<SURVEYS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<SURVEYS>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<SURVEYS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<SURVEYS>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        #endregion

        #region USER_ACTIVITY_LOG
        #endregion

        #region USER_ROLES

        public static USER_ROLES USER_ROLES_GET_BY_USERID_ROLEID(string CURRENT_USER, int CURRENT_REGISTRY_ID, int USER_ID, int STD_ROLE_ID)
        {
            return services.USER_ROLES_GET_BY_USERID_ROLEID(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, STD_ROLE_ID);
        }

        public static USER_ROLES USER_ROLES_GET_BY_USER_ROLE(string Username, string RoleName)
        {
            return services.USER_ROLES_GET_BY_USER_ROLE(Username, RoleName);
        }

        public static string[] USER_ROLES_GET_ROLES(string Username)
        {
            return services.USER_ROLES_GET_ROLES(Username);
        }

        public static List<USER_ROLES> USER_ROLES_GET_ALL_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID, int USER_ID)
        {
            USER_ROLES[] temp = services.USER_ROLES_GET_ALL_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID);
            if (temp != null)
                return temp.ToList<USER_ROLES>();
            return null;
        }

        public static bool USER_ROLES_DELETE_BY_USER_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int USER_ID, int STD_REGISTRY_ID)
        {
            return services.USER_ROLES_DELETE_BY_USER_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID, USER_ID, STD_REGISTRY_ID);
        }

        public static bool USER_ROLES_SAVE_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID, List<USER_ROLES> USER_ROLES)
        {
            if (USER_ROLES == null)
                return false;

            USER_ROLES[] temp = USER_ROLES.ToArray();
            return services.USER_ROLES_SAVE_ALL(CURRENT_USER, CURRENT_REGISTRY_ID, temp);
        }

        public static bool USER_ROLES_ACCESS_BY_REGISTRYID_USERNAME(string CURRENT_USER, int REGISTRY_ID)
        {
            string[] temp = services.USER_ROLES_GET_BY_REGISTRYID_USERNAME(CURRENT_USER, REGISTRY_ID);
            if (temp != null)
            {
                List<string> roleList = temp.ToList();
                if (roleList != null)
                {
                    foreach (string role in roleList)
                    {
                        if (role.ToUpper() == "CRSADMIN" || role.ToUpper() == "CRSUPD" || role.ToUpper() == "CRSREAD")
                            return true;

                        if (role.ToUpper() == "REGADMIN" || role.ToUpper() == "REGUPD" || role.ToUpper() == "REGREAD")
                            return true;
                    }
                }
            }

            return false;
        }

        public static bool USER_ROLES_GET_BY_REGISTRYID_USERNAME_SET_READONLY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            string[] temp = services.USER_ROLES_GET_BY_REGISTRYID_USERNAME(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
            {
                List<string> roleList = temp.ToList();
                bool isAdmin = false;
                bool canEdit = false;
                bool hasRead = false;
                UserSession userSession = (UserSession)HttpContext.Current.Session["UserSession"];
                if (userSession == null) userSession = new UserSession();

                if (roleList != null)
                {
                    for (int i = 0; i < roleList.Count; i++)
                    {
                        if (roleList[i].ToUpper() == "CRSADMIN" || roleList[i].ToUpper() == "REGADMIN")
                        {
                            if (roleList[i].ToUpper() == "CRSADMIN") { userSession.IsSystemAdministrator = true; }
                            if (roleList[i].ToUpper() == "REGADMIN") { userSession.IsRegistryAdministrator = true; }
                            isAdmin = true;
                            break;
                        }
                    }
                    //Admins supercede the following roles - why check for them if user is admin
                    if (isAdmin == false)
                    {
                        for (int i = 0; i < roleList.Count; i++)
                        {
                            if (roleList[i].ToUpper() == "CRSUPD" || roleList[i].ToUpper() == "REGUPD")
                            {
                                canEdit = true;
                                break;
                            }
                            if (roleList[i].ToUpper() == "CRSREAD" || roleList[i].ToUpper() == "REGREAD")
                            {
                                hasRead = true;
                                break;
                            }
                        }
                    }
                    /* JUST MADE THE LOGIC SIMPLIER - HEATH - AND RETURN BASED IN THE ORDER OF THE ROLE VALUE SIGNIFICANCE */
                    if (isAdmin)
                    {
                        return false;
                    }
                    if (canEdit)
                    {
                        return false;
                    }
                    if (hasRead)
                    {
                        return true;
                    }
                }
                else
                {
                    return true;
                }
            }
            return true;
        }

        #endregion

        #region USERS

        public static USERS USERS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.USERS_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<USERS> USERS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            USERS[] temp = services.USERS_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<USERS>();
            return null;
        }

        public static int USERS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, USERS objSave)
        {
            return services.USERS_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean USERS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.USERS_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static DomainNames USERS_LOAD_FROM_AD()
        {
            return services.USERS_LOAD_FROM_AD();
        }

        public static List<DomainUser> USERS_GET_ALL_BY_AD(DomainNames domainNames, string searchString)
        {
            DomainUser[] temp = services.USERS_GET_ALL_BY_AD(domainNames, searchString);
            if (temp != null)
                return temp.ToList<DomainUser>();
            return null;
        }

        public static List<DomainUser> USERS_GET_ALL_BY_AD(DomainNames domainNames, string searchString, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<DomainUser> objReturn = USERS_GET_ALL_BY_AD(domainNames, searchString);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<DomainUser>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<DomainUser>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<DomainUser>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<DomainUser>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<DomainUser>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<DomainUser>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<DomainUser>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<DomainUser>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<DomainUser>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static USERS USERS_GET_BY_NAME(string CURRENT_USER, int CURRENT_REGISTRY_ID, string username)
        {
            return services.USERS_GET_BY_NAME(CURRENT_USER, CURRENT_REGISTRY_ID, username);
        }

        public static List<USERS> USERS_GET_ALL_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            USERS[] temp = services.USERS_GET_ALL_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<USERS>();
            return null;
        }

        public static List<USERS> USERS_GET_ALL_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<USERS> objReturn = USERS_GET_ALL_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<USERS>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<USERS>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<USERS>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<USERS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<USERS>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<USERS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<USERS>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<USERS>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<USERS>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static bool USERS_DEFAULT_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, bool IS_DEFAULT)
        {
            return services.USERS_DEFAULT_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID, IS_DEFAULT);
        }

        #endregion 

        #region AHOBPR USERS
        public AHOBPR_USER AHOBPR_USER_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            AHOBPR_USER sAhobprUser = services.AHOBPRUSERS_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
            USERS sUser = services.USERS_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
            sAhobprUser.USER = sUser;

            return sAhobprUser;
        }

        public int AHOBPRUSERS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, AHOBPR_USER objSave)
        {
            int i = 0;
            int j = 0;

            // Save both the User and AHOBPR User entry
            if (objSave.USER != null)
            {
                i = USERS_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.USER);
            }

            j = services.AHOBPRUSERS_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            if (i <= 0 || j <= 0)
            {
                return -1;
            }
            else
            {
                return j;
            }
        }

        public int SaveUserStateFilter(string identity, int registryId, USER_STATES_FILTER objSave)
        {
            int i = services.SaveUserStateFilter(identity, registryId, objSave);

            return i;
        }

        public USER_STATES_FILTER GetUserStateFilter(string identity, int registryId, int id)
        {
            USER_STATES_FILTER usf = services.GetStatesFilter(identity, registryId, id);

            return usf;
        }
        #endregion

        #region WKF_CASE

        public static WKF_CASE WKF_CASE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.WKF_CASE_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static WKF_CASE WKF_CASE_GET_BY_ACTIVITY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID)
        {
            return services.WKF_CASE_GET_BY_ACTIVITY(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
        }

        public static int WKF_CASE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, WKF_CASE objSave)
        {
            return services.WKF_CASE_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean WKF_CASE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.WKF_CASE_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<WKF_CASE> WKF_CASE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            WKF_CASE[] temp = services.WKF_CASE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<WKF_CASE>();
            return null;
        }

        public static List<WKF_CASE> WKF_CASE_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<WKF_CASE> objReturn = WKF_CASE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (PATIENT_ID > 0)
                {
                    objReturn = objReturn.Where(x => x.PATIENT_ID == PATIENT_ID).ToList();
                }
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<WKF_CASE>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<WKF_CASE> WKF_CASE_GET_ALL_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int REFERRAL_ID)
        {
            WKF_CASE[] temp = services.WKF_CASE_GET_ALL_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);
            if (temp != null)
                return temp.ToList<WKF_CASE>();
            return null;
        }

        public static bool WKF_CASE_UPDATE_STATUS(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID, int STD_WKFCASESTS_ID)
        {
            return services.WKF_CASE_UPDATE_STATUS(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID, STD_WKFCASESTS_ID);
        }

        public static List<LabKitOrderPatientsBO> LabKitOrders_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID, Int32 STD_INSTITUTION_ID, Int32 STD_WKFCASETYPE_ID)
        {
            LabKitOrderPatientsBO[] temp = services.LabKitOrders_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID, STD_INSTITUTION_ID, STD_WKFCASETYPE_ID);
            if (temp != null)
                return temp.ToList<LabKitOrderPatientsBO>();
            return null;
        }

        public static List<LabKitOrderPatientsBO> GetNewLabKitOrders(string CURRENT_USER, int CURRENT_REGISTRY_ID, Int32 instId, Int32 kitTypeId)
        {
            List<LabKitOrderPatientsBO> temp = LabKitOrders_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID, instId, kitTypeId);
            if (temp != null)
            {
                //temp = temp.Where(k => k.StatusId == 4).ToList();
                //if (!string.IsNullOrEmpty(lastName))
                //    temp = temp.Where(k => k.PatientName.Contains(lastName)).ToList();

                //if (!string.IsNullOrEmpty(facilityId))
                //{
                //    int id = 0;
                //    if (int.TryParse(facilityId, out id))
                //    {
                //        temp = temp.Where(k => k.InstId == id).ToList();
                //    }
                //}
                return temp;
            }
            return null;
        }

        public static List<LabKitOrderPatientsBO> GetNewLabKitOrders(string CURRENT_USER, int CURRENT_REGISTRY_ID, Int32 instId, Int32 kitTypeId, int startRow, string sort, int maxRows)
        {
            List<LabKitOrderPatientsBO> temp = GetNewLabKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID, instId, kitTypeId);
            if (temp != null)
                return temp.Skip(startRow).Take(maxRows).ToList();
            //return temp.OrderBy(sort).Skip(startRow).Take(maxRows).ToList();
            return null;
        }

        public static int GetNewLabKitOrdersCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, Int32 instId, Int32 kitTypeId)
        {
            List<LabKitOrderPatientsBO> temp = GetNewLabKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID, instId, kitTypeId);
            if (temp != null)
                return temp.Count();
            return 0;
        }

        public static List<LabKitOrderGroup> KitOrderGroups_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            LabKitOrderGroup[] temp = services.KitOrderGroups_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<LabKitOrderGroup>();
            return null;
        }

        public static List<LabKitOrderGroup> GetPatientsForNewKitOrders(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<LabKitOrderGroup> temp = KitOrderGroups_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (!string.IsNullOrEmpty(lastName))
            {
                temp = temp.Where(w => w.Patient != null).ToList();
                temp = temp.Where(w => Array.Exists(w.Patient, s => s.ToUpper().Contains(lastName.ToUpper()))).ToList();
            }
            else if (!string.IsNullOrEmpty(facilityId))
            {
                temp = temp.Where(w => w.InstitutionId != null).ToList();
                temp = temp.Where(w => w.InstitutionId.ToString() == facilityId).ToList();
            }
            return temp;
        }

        public static List<LabKitOrderGroup> GetPatientsForNewKitOrders(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId, int startRow, string sort, int maxRows)
        {
            List<LabKitOrderGroup> temp = GetPatientsForNewKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);
            if (!string.IsNullOrEmpty(sort))
            {
                temp = temp.SortBy<LabKitOrderGroup>(sort).ToList();
            }
            temp = temp.Skip(startRow).Take(maxRows).ToList();

            return temp;
        }

        public static int GetPatientsForNewKitOrdersCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<LabKitOrderGroup> temp = GetPatientsForNewKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);
            if (temp != null)
                return temp.Count();
            return 0;
        }

        #endregion

        #region WKF_CASE_ACTIVITY

        public static WKF_CASE_ACTIVITY WKF_CASE_ACTIVITY_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.WKF_CASE_ACTIVITY_GET(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int WKF_CASE_ACTIVITY_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objSave)
        {
            return services.WKF_CASE_ACTIVITY_SAVE(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static int WKF_CASE_ACTIVITY_SAVEALL(string CURRENT_USER, int CURRENT_REGISTRY_ID, List<WKF_CASE_ACTIVITY> objSave)
        {
            WKF_CASE_ACTIVITY[] temp = (objSave != null ? objSave.ToArray() : null);
            return services.WKF_CASE_ACTIVITY_SAVEALL(CURRENT_USER, CURRENT_REGISTRY_ID, temp);
        }

        public static Boolean WKF_CASE_ACTIVITY_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return services.WKF_CASE_ACTIVITY_DELETE(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            WKF_CASE_ACTIVITY[] temp = services.WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<WKF_CASE_ACTIVITY>();
            return null;
        }

        public static List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<WKF_CASE_ACTIVITY> objReturn = WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null && objReturn.Count != 0)
            {
                if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                {
                    if (SEARCH_COLUMN.Contains("."))
                    {
                        string[] props = SEARCH_COLUMN.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE_ACTIVITY>();
                        }
                        else if (props != null && props.Count() == 3)
                        {
                            objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                    else
                    {
                        objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<WKF_CASE_ACTIVITY>();
                        objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE_ACTIVITY>();
                    }
                }
                if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                {
                    if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                    {
                        SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                        if (SORT_EXPRESSION.Contains("."))
                        {
                            string[] props = SORT_EXPRESSION.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                            }
                            else if (props != null && props.Count() == 3)
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)))).ToList<WKF_CASE_ACTIVITY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                    else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                    {
                        SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                        if (SORT_EXPRESSION.Contains("."))
                        {
                            string[] props = SORT_EXPRESSION.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                            }
                            else if (props != null && props.Count() == 3)
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)))).ToList<WKF_CASE_ACTIVITY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                    else
                    {
                        if (SORT_EXPRESSION.Contains("."))
                        {
                            string[] props = SORT_EXPRESSION.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                            }
                            else if (props != null && props.Count() == 3)
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)))).ToList<WKF_CASE_ACTIVITY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID)
        {
            WKF_CASE_ACTIVITY[] temp = services.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);
            if (temp != null)
                return temp.ToList<WKF_CASE_ACTIVITY>();
            return null;
        }

        public static List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<WKF_CASE_ACTIVITY> objReturn = WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);
            if (objReturn != null && objReturn.Count != 0)
            {
                if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                {
                    if (SEARCH_COLUMN.Contains("."))
                    {
                        string[] props = SEARCH_COLUMN.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE_ACTIVITY>();
                        }
                        else if (props != null && props.Count() == 3)
                        {
                            // objReturn = objReturn.Where(s => s.GetType().GetProperty(props[1]).GetValue(s).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                    else
                    {
                        objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<WKF_CASE_ACTIVITY>();
                        objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE_ACTIVITY>();
                    }
                }
                if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                {
                    if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                    {
                        SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                        if (SORT_EXPRESSION.Contains("."))
                        {
                            string[] props = SORT_EXPRESSION.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                            }
                            else if (props != null && props.Count() == 3)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[1]).GetValue(s).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<WKF_CASE_ACTIVITY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                    else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                    {
                        SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                        if (SORT_EXPRESSION.Contains("."))
                        {
                            string[] props = SORT_EXPRESSION.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                            }
                            else if (props != null && props.Count() == 3)
                            {
                            }
                        }
                        else
                        {
                            objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                    else
                    {
                        if (SORT_EXPRESSION.Contains("."))
                        {
                            string[] props = SORT_EXPRESSION.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                            }
                            else if (props != null && props.Count() == 3)
                            {
                                // objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[2]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                                //   objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s).GetType().GetProperty(props[2]).GetValue(s.GetType().GetProperty(props[1]).GetValue(s))).ToList<WKF_CASE_ACTIVITY>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<WKF_CASE_ACTIVITY>();
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<LabOrderByStatus> WKF_CASE_ACTIVITY_GET_ALL_BY_STATUS(string CURRENT_USER, int CURRENT_REGISTRY_ID, int STD_WKFACTIVITYSTS_ID)
        {
            LabOrderByStatus[] temp = services.WKF_CASE_ACTIVITY_GET_ALL_BY_STATUS(CURRENT_USER, CURRENT_REGISTRY_ID, STD_WKFACTIVITYSTS_ID);
            if (temp != null)
                return temp.ToList<LabOrderByStatus>();
            return null;
        }

        public static List<LabOrderByStatus> SelectByStatus(string CURRENT_USER, int CURRENT_REGISTRY_ID, string searchCriteria, string searchValue, int id)
        {
            List<LabOrderByStatus> objReturn = SelectByStatus(CURRENT_USER, CURRENT_REGISTRY_ID, searchCriteria, searchValue, id, 0, "", -1);

            return objReturn;
        }

        public static List<LabOrderByStatus> SelectByStatus(string CURRENT_USER, int CURRENT_REGISTRY_ID, string searchCriteria, string searchValue, int id, int startRow, string sort, int maxRows)
        {
            List<LabOrderByStatus> objReturn = WKF_CASE_ACTIVITY_GET_ALL_BY_STATUS(CURRENT_USER, CURRENT_REGISTRY_ID, id);

            if (!string.IsNullOrEmpty(searchCriteria) && !string.IsNullOrEmpty(searchValue))
            {
                if (searchCriteria.Contains("."))
                {
                    string[] props = searchCriteria.Split('.');
                    if (props != null && props.Count() == 2)
                    {
                        if (objReturn.Any(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)) != null))
                        {
                            objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(searchValue.ToLower())).ToList();
                        }
                        else
                        {
                            objReturn = new List<LabOrderByStatus>();
                        }
                    }
                }
                else
                {
                    objReturn = objReturn.Where(w => w.GetType().GetProperty(searchCriteria).GetValue(w) != null).ToList();
                    objReturn = objReturn.Where(w => w.GetType().GetProperty(searchCriteria).GetValue(w).ToString().ToLower().Contains(searchValue.ToLower())).ToList();
                }
            }

            if (!string.IsNullOrEmpty(sort))
            {
                objReturn = objReturn.SortBy<LabOrderByStatus>(sort).ToList();
            }

            if (maxRows != -1)
            {
                objReturn = objReturn.Skip(startRow).Take(maxRows).ToList();
            }

            return objReturn;
        }

        public static int SelectByStatusCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, string searchCriteria, string searchValue, int id)
        {
            int objReturn = 0;
            List<LabOrderByStatus> temp = SelectByStatus(CURRENT_USER, CURRENT_REGISTRY_ID, searchCriteria, searchValue, id);
            if (temp != null)
                objReturn = temp.Count();
            return objReturn;
        }

        public static bool WKF_CASE_ACTIVITY_UPDATE_STATUS(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ACTIVITY_ID, int STD_WKFACTIVITYSTS_ID)
        {
            return services.WKF_CASE_ACTIVITY_UPDATE_STATUS(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID, STD_WKFACTIVITYSTS_ID);
        }

        public static List<KitOrders> KitOrders_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            KitOrders[] temp = services.KitOrders_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<KitOrders>();
            return null;
        }

        public static List<KitOrders> GetOrderedKitOrders(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<KitOrders> temp = KitOrders_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
            {
                temp = temp.Where(k => k.StatusId == 4).ToList();
                if (!string.IsNullOrEmpty(lastName))
                    temp = temp.Where(k => k.PatientName.ToUpper().Contains(lastName.ToUpper())).ToList();

                if (!string.IsNullOrEmpty(facilityId))
                {
                    int id = 0;
                    if (int.TryParse(facilityId, out id))
                    {
                        temp = temp.Where(k => k.InstId == id).ToList();
                    }
                }
                return temp;
            }
            return null;
        }

        public static List<KitOrders> GetOrderedKitOrders(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId, int startRow, string sort, int maxRows)
        {
            List<KitOrders> temp = GetOrderedKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);

            if (temp != null)
            {
                if (string.IsNullOrEmpty(sort))
                    sort = "WkfCaseId desc";

                if (sort.Length >= 4 && sort.Substring(sort.Length - 4, 4).ToUpper() == "DESC")
                {
                    sort = sort.Substring(0, sort.Length - 5);

                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderByDescending(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }
                else
                {
                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderBy(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }

                return temp.Skip(startRow).Take(maxRows).ToList();
            }

            return null;
        }

        public static int GetOrderedKitOrdersCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<KitOrders> temp = GetOrderedKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);
            if (temp != null)
                return temp.Count();
            return 0;
        }

        public static List<KitOrders> GetLabKitsReturned(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<KitOrders> temp = KitOrders_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
            {
                temp = temp.Where(k => k.StatusId == 5).ToList();
                if (!string.IsNullOrEmpty(lastName))
                    temp = temp.Where(k => k.PatientName.ToUpper().Contains(lastName.ToUpper())).ToList();

                if (!string.IsNullOrEmpty(facilityId))
                {
                    int id = 0;
                    if (int.TryParse(facilityId, out id))
                    {
                        temp = temp.Where(k => k.InstId == id).ToList();
                    }
                }
                return temp;
            }
            return null;
        }

        public static List<KitOrders> GetLabKitsReturned(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId, int startRow, string sort, int maxRows)
        {
            List<KitOrders> temp = GetLabKitsReturned(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);

            if (temp != null)
            {
                if (string.IsNullOrEmpty(sort))
                    sort = "WkfCaseId desc";

                if (sort.Length >= 4 && sort.Substring(sort.Length - 4, 4).ToUpper() == "DESC")
                {
                    sort = sort.Substring(0, sort.Length - 5);

                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderByDescending(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }
                else
                {
                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderBy(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }

                return temp.Skip(startRow).Take(maxRows).ToList();
            }

            return null;
        }

        public static int GetLabKitsReturnedCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<KitOrders> temp = GetLabKitsReturned(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);
            if (temp != null)
                return temp.Count();
            return 0;
        }

        public static List<KitOrders> GetLabKitsCanceled(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<KitOrders> temp = KitOrders_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
            {
                temp = temp.Where(k => k.StatusId == 3).ToList();
                if (!string.IsNullOrEmpty(lastName))
                    temp = temp.Where(k => k.PatientName.ToUpper().Contains(lastName.ToUpper())).ToList();

                if (!string.IsNullOrEmpty(facilityId))
                {
                    int id = 0;
                    if (int.TryParse(facilityId, out id))
                    {
                        temp = temp.Where(k => k.InstId == id).ToList();
                    }
                }
                return temp;
            }
            return null;
        }

        public static List<KitOrders> GetLabKitsCanceled(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId, int startRow, string sort, int maxRows)
        {
            List<KitOrders> temp = GetLabKitsCanceled(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);

            if (temp != null)
            {
                if (string.IsNullOrEmpty(sort))
                    sort = "WkfCaseId desc";

                if (sort.Length >= 4 && sort.Substring(sort.Length - 4, 4).ToUpper() == "DESC")
                {
                    sort = sort.Substring(0, sort.Length - 5);

                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderByDescending(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }
                else
                {
                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderBy(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }

                return temp.Skip(startRow).Take(maxRows).ToList();
            }

            return null;
        }

        public static int GetLabKitsCanceledCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, string lastName, string facilityId)
        {
            List<KitOrders> temp = GetLabKitsCanceled(CURRENT_USER, CURRENT_REGISTRY_ID, lastName, facilityId);
            if (temp != null)
                return temp.Count();
            return 0;
        }

        public static List<KeyValuePair<int, string>> GetOrderStatusByActivityID(string CURRENT_USER, int CURRENT_REGISTRY_ID, int activityId)
        {
            List<KeyValuePair<int, string>> objReturn = new List<KeyValuePair<int, string>>();

            WKF_CASE_ACTIVITY activity = WKF_CASE_ACTIVITY_GET(CURRENT_USER, CURRENT_REGISTRY_ID, activityId);
            if (activity != null)
            {
                objReturn.Add(new KeyValuePair<int, string>(activity.WKF_CASE_ID, activity.STD_WKFACTIVITYSTS.NAME));
            }

            return objReturn;
        }

        public static LabOrderPatient GetPatientByActivityId(string CURRENT_USER, int CURRENT_REGISTRY_ID, int activityId)
        {
            return services.LabOrderPatient_GET(CURRENT_USER, CURRENT_REGISTRY_ID, activityId);
        }

        public static List<LabResult> LabResult_GET_NEW(string CURRENT_USER, int CURRENT_REGISTRY_ID, int activityStatusId)
        {
            LabResult[] temp = services.LabResult_GET_NEW(CURRENT_USER, CURRENT_REGISTRY_ID, activityStatusId);
            if (temp != null)
                return temp.ToList<LabResult>();
            return null;
        }

        public static List<LabResult> GetNewLabResults(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id, string searchValue)
        {
            List<LabResult> temp = LabResult_GET_NEW(CURRENT_USER, CURRENT_REGISTRY_ID, id);
            if (temp != null)
            {
                if (!string.IsNullOrEmpty(searchValue))
                    temp = temp.Where(t => t.PatientName.ToUpper().Contains(searchValue.ToUpper())).ToList();
            }
            return temp;
        }

        public static List<LabResult> GetNewLabResults(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id, string searchValue, int startRow, string sort, int maxRows)
        {
            List<LabResult> temp = LabResult_GET_NEW(CURRENT_USER, CURRENT_REGISTRY_ID, id);
            if (temp != null)
            {
                if (!string.IsNullOrEmpty(searchValue))
                    temp = temp.Where(t => t.PatientName.ToUpper().Contains(searchValue.ToUpper())).ToList();

                if (string.IsNullOrEmpty(sort))
                    sort = "CaseId desc";

                if (sort.Length >= 4 && sort.Substring(sort.Length - 4, 4).ToUpper() == "DESC")
                {
                    sort = sort.Substring(0, sort.Length - 5);

                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderByDescending(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }
                else
                {
                    if (sort.Contains("."))
                    {
                        string[] props = sort.Split('.');
                        if (props != null && props.Count() == 2)
                        {
                            temp = temp.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList();
                        }
                    }
                    else
                        temp = temp.OrderBy(s => s.GetType().GetProperty(sort).GetValue(s)).ToList();
                }

                temp = temp.Skip(startRow).Take(maxRows).ToList();
            }

            return temp;
        }

        public static int GetNewLabResultsCount(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id, string searchValue)
        {
            List<LabResult> temp = GetNewLabResults(CURRENT_USER, CURRENT_REGISTRY_ID, id, searchValue);
            if (temp != null)
                return temp.Count();
            return 0;
        }

        public static List<KeyValuePair<int, string>> GetInsitutionList(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            List<KeyValuePair<int, string>> objReturn = new List<KeyValuePair<int, string>>();

            List<STD_INSTITUTION> instList = STD_INSTITUTION_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (instList != null)
            {
                objReturn = instList.Where(inst => inst.VISN_ID != null).OrderBy(o => o.STATIONNUMBER).Select(s => new KeyValuePair<int, string>(s.ID, "(" + s.STATIONNUMBER + ") " + s.NAME.Replace("\"", ""))).ToList();
            }
            else
                objReturn = new List<KeyValuePair<int, string>>();

            return objReturn;
        }

        public static List<STD_INSTITUTION> GetVISNOnlyList(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            List<STD_INSTITUTION> instList = STD_INSTITUTION_GET_ALL(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (instList != null)
            {
                instList = instList.Where(inst => inst.STD_FACILITYTYPE_ID == 1009241).OrderBy(o => o.ID).ToList();
            }
            else
                instList = new List<STD_INSTITUTION>();

            return instList;
        }

        #endregion

        #region WKF_CASE_ASSIGNMENT
        #endregion

        #region WKF_CASE_COMMENTS
        #endregion

        #region LOGS

        public static void LogDetails(LogDetails logDetails)
        {
            services.LOG_DETAILS(logDetails);
        }

        public static void LogTiming(LogDetails logDetails)
        {
            services.LOG_TIMING(logDetails);
        }

        public static void LogInformation(string message, string processName, string username, int registryId)
        {
            services.LOG_INFORMATION(message, processName, username, registryId);
        }

        public static void LogError(string message, string processName, string username, int registryId)
        {
            services.LOG_ERROR(message, processName, username, registryId);
        }

        #endregion

        #region REPORTS

        public static List<ReportItem> REPORTS_GET_ALL_BY_USER_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            ReportItem[] temp = services.REPORTS_GET_ALL_BY_USER_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<ReportItem>();
            return null;
        }

        public static List<ReportItem> REPORTS_GET_ALL_BY_USER_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            List<ReportItem> objReturn = REPORTS_GET_ALL_BY_USER_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (objReturn != null)
            {
                if (objReturn != null && objReturn.Count != 0)
                {
                    if (!string.IsNullOrEmpty(SEARCH_COLUMN) && !string.IsNullOrEmpty(SEARCH_TEXT))
                    {
                        if (SEARCH_COLUMN.Contains("."))
                        {
                            string[] props = SEARCH_COLUMN.Split('.');
                            if (props != null && props.Count() == 2)
                            {
                                objReturn = objReturn.Where(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s)).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<ReportItem>();
                            }
                        }
                        else
                        {
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w) != null).ToList<ReportItem>();
                            objReturn = objReturn.Where(w => w.GetType().GetProperty(SEARCH_COLUMN).GetValue(w).ToString().ToLower().Contains(SEARCH_TEXT.ToLower())).ToList<ReportItem>();
                        }
                    }
                    if (!string.IsNullOrEmpty(SORT_EXPRESSION))
                    {
                        if (SORT_EXPRESSION.Length >= 4 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 4, 4).ToUpper() == "DESC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 5);

                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<ReportItem>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderByDescending(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<ReportItem>();
                            }
                        }
                        else if (SORT_EXPRESSION.Length >= 3 && SORT_EXPRESSION.Substring(SORT_EXPRESSION.Length - 3, 3).ToUpper() == "ASC")
                        {
                            SORT_EXPRESSION = SORT_EXPRESSION.Substring(0, SORT_EXPRESSION.Length - 4);
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<ReportItem>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<ReportItem>();
                            }
                        }
                        else
                        {
                            if (SORT_EXPRESSION.Contains("."))
                            {
                                string[] props = SORT_EXPRESSION.Split('.');
                                if (props != null && props.Count() == 2)
                                {
                                    objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(props[0]).GetValue(s).GetType().GetProperty(props[1]).GetValue(s.GetType().GetProperty(props[0]).GetValue(s))).ToList<ReportItem>();
                                }
                                else if (props != null && props.Count() == 3)
                                {
                                }
                            }
                            else
                            {
                                objReturn = objReturn.OrderBy(s => s.GetType().GetProperty(SORT_EXPRESSION).GetValue(s)).ToList<ReportItem>();
                            }
                        }
                    }
                }
            }

            return objReturn;
        }

        public static List<ReportItem> REPORTS_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            ReportItem[] temp = services.REPORTS_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<ReportItem>();
            return null;
        }

        public static List<ReportItem> REPORTS_GET_ALL_SYSTEM(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            ReportItem[] temp = services.REPORTS_GET_ALL_SYSTEM(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<ReportItem>();
            return null;
        }

        public static List<ReportItem> REPORTS_GET_ALL_BY_USER(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            ReportItem[] temp = services.REPORTS_GET_ALL_BY_USER(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<ReportItem>();
            return null;
        }

        public static bool REPORTS_UPDATE_ITEM_PROPERTIES(string CURRENT_USER, int CURRENT_REGISTRY_ID, string ITEM_PATH, string DESCRIPTION)
        {
            return services.REPORTS_UPDATE_ITEM_PROPERTIES(CURRENT_USER, CURRENT_REGISTRY_ID, ITEM_PATH, DESCRIPTION);
        }

        #endregion

        #region APPSETTINGS

        public static AppSettings APPSETTINGS_GET(string identity, int registryId)
        {
            return services.APPSETTINGS_GET(identity, registryId);
        }

        public static bool APPSETTINGS_SAVE(string identity, int registryId, AppSettings appSettings)
        {
            return services.APPSETTINGS_SAVE(identity, registryId, appSettings);
        }

        public static void APPSETTINGS_SAVE_TO_CONFIG(AppSettings appSettings)
        {
            try
            {
                services.APPSETTINGS_SAVE_TO_CONFIG(appSettings);
            }
            catch //(Exception ex)
            {
                //Do nothing, error has already been logged
            }
        }

        public static string REPORTS_GET_SERVER_URL()
        {
            return services.REPORTS_GET_SERVER_URL();
        }

        public static string REPORTS_GET_BUILDER_URL()
        {
            return services.REPORTS_GET_BUILDER_URL();
        }

        public static int GET_SQL_COMMAND_TIMEOUT()
        {
            return services.GET_SQL_COMMAND_TIMEOUT();
        }

        #endregion

        #region MVI

        public static bool PRPA_IN201305UV02(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_PATIENT_ID, int MVI_TYPE_ID)
        {
            //Moved MVI functionality to it's own service endpoint, 
            //will need to add a new service reference if MVI functionality is needed in the GUI
            //return services.PRPA_IN201305UV02(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_PATIENT_ID, MVI_TYPE_ID);
            return false;
        }

        public static bool PRPA_IN201309UV02(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_PATIENT_ID)
        {
            //Moved MVI functionality to it's own service endpoint, 
            //will need to add a new service reference if MVI functionality is needed in the GUI
            //return services.PRPA_IN201309UV02(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_PATIENT_ID);
            return false;
        }

        #endregion

        #region FRAMEWORK_DATA

        public static ENC_ENCOUNTER ENC_ENCOUNTER_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            ENC_ENCOUNTER[] temp = services.ENC_ENCOUNTER_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<ENC_ENCOUNTER>().FirstOrDefault();
            return null;
        }

        public static ALLERGY ALLERGY_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            ALLERGY[] temp = services.ALLERGY_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<ALLERGY>().FirstOrDefault();
            return null;
        }

        public static A06_AUDIOMETRIC_EXAM_DATA_509850_9 A06_AUDIOMETRIC_EXAM_DATA_509850_9_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            A06_AUDIOMETRIC_EXAM_DATA_509850_9[] temp = services.A06_AUDIOMETRIC_EXAM_DATA_509850_9_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<A06_AUDIOMETRIC_EXAM_DATA_509850_9>().FirstOrDefault();
            return null;
        }

        public static CONSULT CONSULT_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            CONSULT[] temp = services.CONSULT_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<CONSULT>().FirstOrDefault();
            return null;
        }

        public static EDISLOG EDISLOG_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            EDISLOG[] temp = services.EDISLOG_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<EDISLOG>().FirstOrDefault();
            return null;
        }

        public static IMMUNIZATION IMMUNIZATION_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            IMMUNIZATION[] temp = services.IMMUNIZATION_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<IMMUNIZATION>().FirstOrDefault();
            return null;
        }

        public static INPAT_INPATIENT INPAT_INPATIENT_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            INPAT_INPATIENT[] temp = services.INPAT_INPATIENT_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<INPAT_INPATIENT>().FirstOrDefault();
            return null;
        }

        public static INPAT_CENSUS INPAT_CENSUS_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            INPAT_CENSUS[] temp = services.INPAT_CENSUS_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<INPAT_CENSUS>().FirstOrDefault();
            return null;
        }

        public static INPATIENT_DIAGNOSIS INPATIENT_DIAGNOSIS_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            INPATIENT_DIAGNOSIS[] temp = services.INPATIENT_DIAGNOSIS_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<INPATIENT_DIAGNOSIS>().FirstOrDefault();
            return null;
        }

        public static CHEM_LABCHEM CHEM_LABCHEM_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            CHEM_LABCHEM[] temp = services.CHEM_LABCHEM_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<CHEM_LABCHEM>().FirstOrDefault();
            return null;
        }

        public static OUTPAT_VISIT OUTPAT_VISIT_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            OUTPAT_VISIT[] temp = services.OUTPAT_VISIT_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<OUTPAT_VISIT>().FirstOrDefault();
            return null;
        }

        public static SCONSULT_REASON SCONSULT_REASON_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            SCONSULT_REASON[] temp = services.SCONSULT_REASON_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<SCONSULT_REASON>().FirstOrDefault();
            return null;
        }

        public static PATSUB_SECONDARYELIGIBILITY PATSUB_SECONDARYELIGIBILITY_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            PATSUB_SECONDARYELIGIBILITY[] temp = services.PATSUB_SECONDARYELIGIBILITY_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<PATSUB_SECONDARYELIGIBILITY>().FirstOrDefault();
            return null;
        }

        public static PATIENT_ENROLLMENT PATIENT_ENROLLMENT_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            PATIENT_ENROLLMENT[] temp = services.PATIENT_ENROLLMENT_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<PATIENT_ENROLLMENT>().FirstOrDefault();
            return null;
        }

        public static PATIENT_ETHNICITY PATIENT_ETHNICITY_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            PATIENT_ETHNICITY[] temp = services.PATIENT_ETHNICITY_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<PATIENT_ETHNICITY>().FirstOrDefault();
            return null;
        }

        public static A06_SPATIENT_GEOCODEDADDRESS A06_SPATIENT_GEOCODEDADDRESS_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            A06_SPATIENT_GEOCODEDADDRESS[] temp = services.A06_SPATIENT_GEOCODEDADDRESS_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<A06_SPATIENT_GEOCODEDADDRESS>().FirstOrDefault();
            return null;
        }

        public static SPATIENT_SPATIENTINSURANCE SPATIENT_SPATIENTINSURANCE_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            SPATIENT_SPATIENTINSURANCE[] temp = services.SPATIENT_SPATIENTINSURANCE_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<SPATIENT_SPATIENTINSURANCE>().FirstOrDefault();
            return null;
        }

        public static MILITARY_SERVICE_EPISODE MILITARY_SERVICE_EPISODE_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            MILITARY_SERVICE_EPISODE[] temp = services.MILITARY_SERVICE_EPISODE_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<MILITARY_SERVICE_EPISODE>().FirstOrDefault();
            return null;
        }

        public static MILITARY_SEXUAL_TRAUMA MILITARY_SEXUAL_TRAUMA_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            MILITARY_SEXUAL_TRAUMA[] temp = services.MILITARY_SEXUAL_TRAUMA_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<MILITARY_SEXUAL_TRAUMA>().FirstOrDefault();
            return null;
        }

        public static OEFOIF_SERVICE OEFOIF_SERVICE_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            OEFOIF_SERVICE[] temp = services.OEFOIF_SERVICE_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<OEFOIF_SERVICE>().FirstOrDefault();
            return null;
        }

        public static PHARMACY_PATIENT PHARMACY_PATIENT_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            PHARMACY_PATIENT[] temp = services.PHARMACY_PATIENT_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<PHARMACY_PATIENT>().FirstOrDefault();
            return null;
        }

        public static NOSETHROAT_RADIUMHST NOSETHROAT_RADIUMHST_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            NOSETHROAT_RADIUMHST[] temp = services.NOSETHROAT_RADIUMHST_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<NOSETHROAT_RADIUMHST>().FirstOrDefault();
            return null;
        }

        public static SERVICE_CONNECTED_CONDITION SERVICE_CONNECTED_CONDITION_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            SERVICE_CONNECTED_CONDITION[] temp = services.SERVICE_CONNECTED_CONDITION_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<SERVICE_CONNECTED_CONDITION>().FirstOrDefault();
            return null;
        }

        public static PATSUB_VARATEDDISABILITY PATSUB_VARATEDDISABILITY_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            PATSUB_VARATEDDISABILITY[] temp = services.PATSUB_VARATEDDISABILITY_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<PATSUB_VARATEDDISABILITY>().FirstOrDefault();
            return null;
        }

        public static A06_PHARMACY_PATIENT_55X_IV_55_01 A06_PHARMACY_PATIENT_55X_IV_55_01_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            A06_PHARMACY_PATIENT_55X_IV_55_01[] temp = services.A06_PHARMACY_PATIENT_55X_IV_55_01_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<A06_PHARMACY_PATIENT_55X_IV_55_01>().FirstOrDefault();
            return null;
        }

        public static A06_PHARMACY_PATIX_UNIT_DOSE_55_06 A06_PHARMACY_PATIX_UNIT_DOSE_55_06_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            A06_PHARMACY_PATIX_UNIT_DOSE_55_06[] temp = services.A06_PHARMACY_PATIX_UNIT_DOSE_55_06_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<A06_PHARMACY_PATIX_UNIT_DOSE_55_06>().FirstOrDefault();
            return null;
        }

        public static A06_PHARMACY_PATX_NONVA_MEDS_55_05 A06_PHARMACY_PATX_NONVA_MEDS_55_05_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            A06_PHARMACY_PATX_NONVA_MEDS_55_05[] temp = services.A06_PHARMACY_PATX_NONVA_MEDS_55_05_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<A06_PHARMACY_PATX_NONVA_MEDS_55_05>().FirstOrDefault();
            return null;
        }

        public static RXOUTPAT RXOUTPAT_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            RXOUTPAT[] temp = services.RXOUTPAT_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<RXOUTPAT>().FirstOrDefault();
            return null;
        }

        public static OUTPAT_PROBLEMLIST OUTPAT_PROBLEMLIST_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            OUTPAT_PROBLEMLIST[] temp = services.OUTPAT_PROBLEMLIST_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<OUTPAT_PROBLEMLIST>().FirstOrDefault();
            return null;
        }

        public static TIU_TIUDOCUMENT TIU_TIUDOCUMENT_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            TIU_TIUDOCUMENT[] temp = services.TIU_TIUDOCUMENT_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<TIU_TIUDOCUMENT>().FirstOrDefault();
            return null;
        }

        public static RADIOLOGYEXAM RADIOLOGYEXAM_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            RADIOLOGYEXAM[] temp = services.RADIOLOGYEXAM_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<RADIOLOGYEXAM>().FirstOrDefault();
            return null;
        }

        public static SPATIENT_NEW SPATIENT_NEW_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            SPATIENT_NEW[] temp = services.SPATIENT_NEW_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<SPATIENT_NEW>().FirstOrDefault();
            return null;
        }

        public static OUTPAT_VDIAGNOSIS OUTPAT_VDIAGNOSIS_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            OUTPAT_VDIAGNOSIS[] temp = services.OUTPAT_VDIAGNOSIS_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<OUTPAT_VDIAGNOSIS>().FirstOrDefault();
            return null;
        }

        public static VITALSIGN VITALSIGN_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            VITALSIGN[] temp = services.VITALSIGN_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<VITALSIGN>().FirstOrDefault();
            return null;
        }

        public static LabScreening LABSCREENING_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            LabScreening[] temp = services.LABSCREENING_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<LabScreening>().FirstOrDefault();
            return null;
        }

        public static TRACER TRACER_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            TRACER[] temp = services.TRACER_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<TRACER>().FirstOrDefault();
            return null;
        }

        public static APPT_APPOINTMENT APPOINTMENTS_GET_BY_REFERRAL(string CURRENT_USER, int CURRENT_REGISTRY_ID, int CURRENT_REFERRAL_ID)
        {
            APPT_APPOINTMENT[] temp = services.APPOINTMENTS_GET_BY_REFERRAL(CURRENT_USER, CURRENT_REGISTRY_ID, CURRENT_REFERRAL_ID);
            if (temp != null)
                return temp.ToList<APPT_APPOINTMENT>().FirstOrDefault();
            return null;
        }

        public static object GetFrameWorkInfo(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID, Int32 PATIENT_ID, string CURRENT_FRAMEWORK_DATA)
        {
            return services.GetFrameWorkInfo(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, PATIENT_ID, CURRENT_FRAMEWORK_DATA);
        }

        public static List<TableColumnValue> REGISTRY_FRAMEWORK_TABLE_GET_ALL_BY_REGISTRY(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID, Int32 PATIENT_ID, string CURRENT_FRAMEWORK_DATA)
        {
            TableColumnValue[] temp = services.REGISTRY_FRAMEWORK_TABLE_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID, PATIENT_ID, CURRENT_FRAMEWORK_DATA);
            if (temp != null)
                return temp.ToList<TableColumnValue>();
            return null;
        }

        public static List<TableColumnValue> REGISTRY_FRAMEWORK_DATA_GET_ALL_BY_REGISTRY(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            TableColumnValue[] temp = services.REGISTRY_FRAMEWORK_DATA_GET_ALL_BY_REGISTRY(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (temp != null)
                return temp.ToList<TableColumnValue>();
            return null;
        }

        #endregion

        public List<TOOL_QUESTION_DTO> SearchQuestions(string keyWords, string type, string status, string sort, int startRow, int maxRows)
        {
            TOOL_QUESTION_DTO[] temp = services.SearchQuestions(keyWords, type, status, sort, startRow, maxRows, ref this.totalCount);
            if (temp != null)
            {
                //totalCount = temp.Count();
                return temp.ToList<TOOL_QUESTION_DTO>();
            }
            return null;
        }

        public int SearchQuestionsCount(string keyWords, string type, string status, string sort, int startRow, int maxRows)
        {
            return this.totalCount;
        }

        public IEnumerable<TOOL_FORM_DTO> SearchForms(string keyWords, string status, string systemWide, string sort, int startRow, int maxRows)
        {
            TOOL_FORM_DTO[] temp = services.SearchForms(keyWords, status, systemWide, sort, startRow, maxRows, ref this.totalCount);
            if (temp != null)
            {
                //totalCount = temp.Count();
                return temp.ToList<TOOL_FORM_DTO>();
            }
            return null;
        }

        public int SearchFormsCount(string keyWords, string status, string systemWide, string sort, int startRow, int maxRows)
        {
            return this.totalCount;
        }

        public TOOL_FORM_DTO GetFormById(int formId)
        {
            return services.GetFormById(formId);
        }

        public TOOL_QUESTION_DTO GetQuestionById(int questionId)
        {
            return services.GetQuestionById(questionId);
        }

        public List<TOOL_QUESTION_DTO> GetQuestionsByFormId(int formId)
        {
            return services.GetQuestionsByFormId(formId).ToList();
        }

        public int AddQuestionToForm(string CURRENT_USER, int questionId, int formId)
        {
            return services.AddQuestionToForm(CURRENT_USER, questionId, formId);
        }

        public bool RemoveQuestionFromForm(string CURRENT_USER, int questionId, int formId)
        {
            return services.RemoveQuestionFromForm(CURRENT_USER, questionId, formId);
        }

        public int SaveForm(string currentUser, int formId, TOOL_FORM_DTO saveForm)
        {
            return services.SaveForm(currentUser, formId, saveForm);
        }

        public void SubmitFollowUpFormToStdTables(string currentUser, int toolFormId)
        {
            services.SubmitFollowUpFormToStdTables(currentUser, toolFormId);
        }

        public bool RemoveForm(int formId)
        {
            return services.RemoveForm(formId);
        }

        public int SaveQuestion(string currentUser, int questionId, TOOL_QUESTION_DTO saveQuestion)
        {
            return services.SaveQuestion(currentUser, questionId, saveQuestion);
        }

        public List<VIEW_LOOKUP> SelectLookupList(string lookupCategory)
        {
            return services.SelectLookupList(lookupCategory).ToList();
        }

        public bool ActivateDeactivateForm(string currentUser, int formId)
        {
            return services.ActivateDeactivateForm(currentUser, formId);
        }

        public bool ActivateDeactivateQuestion(string currentUser, int questionId)
        {
            return services.ActivateDeactivateQuestion(currentUser, questionId);
        }

        public bool RemoveQuestion(int questionId)
        {
            return services.RemoveQuestion(questionId);
        }

        public static Int32 AUDIT_LOG_Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, AUDIT_LOG objSave)
        {
            return services.AUDIT_LOG_Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }
    }
}
